<?php

namespace App\Http\Livewire\Form\Cpw;

use App\CpwActivity;
use App\CpwActivityValidation;
use App\CpwHeader;
use App\CpwSelected;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Create extends Component
{

    public $mForm;
    public $NoReg;
    public $cpwActivitys;
    public $hari_ke;
    public $activityStatuses = [];
    public $varianInputs = [];
    public $varianValidation = [];
    public $cpwValidation;
    public $show = false;
    public $header_id;
    public $header;
    public $perPage = 5; //Adjust this value as needed
    public $currentPage = 1;
    public $user_id;
    public $date_selected;

    public function mount($mForm, $NoReg, $header_id = null)
    {

        if (!is_null($header_id)) {
            $this->header_id = $header_id;
        } else {
            $this->header_id = null; // Or some default value if needed
        }

        $this->mForm = $mForm;
        $this->NoReg = $NoReg;
        $this->initialize();
    }

    private function afterSave(){
        $this->checkCpwSelected();
        $this->loadCpwActivityValidation();
    }

    private function initialize()
    {
        $this->checkCpwSelected();
        $this->loadCpwActivity();
        $this->initializeActivityStatuses();
        $this->loadCpwActivityValidation();
        $this->user_id = Auth::user()->id;
    
        $this->date_selected = Carbon::now()->toDateString();
    }

    public function loadCpwActivity()
    {
        if ($this->mForm) {
            // Retrieve activities with the first filtered validation
            $this->cpwActivitys = CpwActivity::where('mForm_id', $this->mForm->id)->orderBy('no', 'asc')
                ->get()
                ->map(function ($activity) {
                    $activity->firstValidation = $activity->firstFilteredValidation($this->hari_ke);
                    return $activity;
                });
        } else {
            $this->cpwActivitys = collect(); // Empty collection to avoid null issues
        }
    }


    public function loadCpwActivityValidation()
    {
        // Ensure that cpwActivitys is loaded before proceeding

        if ($this->cpwActivitys && $this->cpwActivitys->isNotEmpty()) {
            $activityIds = $this->cpwActivitys->pluck('id')->toArray();

            $this->cpwValidation = CpwActivityValidation::whereIn('cpw_activity_id', $activityIds)->where('hari_ke', $this->hari_ke)->get();
        } else {

            $this->cpwValidation = collect(); // Empty collection to avoid null issues
        }
    }

    // public function updateActivityStatus($activityId, $status)
    // {
    //     // Update the activity status
    //     $this->activityStatuses[$activityId] = $status;

    //     // If the status is 'Tidak', check the validation requirements
    //     if ($status === 'Tidak') {
    //         // Find the corresponding validation rule for the activity
    //         $checkValidation = $this->cpwValidation->firstWhere('cpw_activity_id', $activityId);

    //         // If the validation is required, set the varianValidation for this activity
    //         if (isset($checkValidation) && $checkValidation->validation === 'required') {
    //             $this->varianValidation[$activityId] = 'required';
    //         } else {
    //             $this->varianValidation[$activityId] = '';
    //             $this->varianInputs[$activityId] = '';
    //         }
    //     } else {
    //         // Reset varianValidation and varianInputs when status is not 'Tidak'
    //         $this->varianValidation[$activityId] = '';
    //         $this->varianInputs[$activityId] = '';
    //     }
    // }
    public function updateActivityStatus($activityId, $status)
    {
        // Update the activity status
        $this->activityStatuses[$activityId] = $status;

        // Pastikan cpwValidation tidak null
        if (is_null($this->cpwValidation)) {
            $this->cpwValidation = collect(); // Atau isi dengan koleksi kosong sebagai fallback
        }

        // Jika status adalah 'Tidak', cek validasi
        if ($status === 'Tidak') {
            // Cari aturan validasi untuk aktivitas
            $checkValidation = $this->cpwValidation->firstWhere('cpw_activity_id', $activityId);

            if ($checkValidation && $checkValidation->validation === 'required') {
                $this->varianValidation[$activityId] = 'required';
            } else {
                $this->varianValidation[$activityId] = '';
                $this->varianInputs[$activityId] = '';
            }
        } else {
            // Reset varianValidation dan varianInputs jika status bukan 'Tidak'
            $this->varianValidation[$activityId] = '';
            $this->varianInputs[$activityId] = '';
        }
    }




    public function checkCpwSelected()
    {
        if (!is_null($this->header_id)) {

            $this->header = CpwHeader::find($this->header_id);
        } else {

            $this->header = CpwHeader::where('NoReg', $this->NoReg)
                ->where('mForm_id', $this->mForm->id)
                ->first();
        }


        if ($this->header) {

            $lastSelected = $this->header->cpwSelected()
                ->orderBy('hari_ke', 'desc')
                ->first();

            if ($lastSelected) {
                $hari_ke = $lastSelected->hari_ke + 1;
            }

            $this->hari_ke = $lastSelected ? $hari_ke : 1;
            $this->show = true;
        } else {

            $this->show = false;
            $this->hari_ke = 1;
        }
    }



    public function initializeActivityStatuses()
    {
        foreach ($this->cpwActivitys as $activity) {
            $this->activityStatuses[$activity->id] = '';
            $this->varianInputs[$activity->id] = '';
        }
    }

    public $rules = [
        'activityStatuses.*' => 'nullable',
        'varianInputs.*' => 'nullable|string|max:100', // If filled, must be a string and within the character limit
    ];

    public $messages = [
        'activityStatuses.*.required' => 'Harus pilih salah satu.', // Custom message for required rule on activityStatuses.*
        'varianInputs.*.string' => 'Input ketrangan harus berupa teks.', // Custom message for string validation on varianInputs.*
        'varianInputs.*.max' => 'Input keterangan tidak boleh lebih dari 100 karakter.', // Custom message for max length on varianInputs.*
    ];





    public function save()
    {

        // Perform validation
        $data = $this->validate();
        $errorsFound = false;
        // Now check if varianInput is required when 'Tidak' is selected
        foreach ($this->activityStatuses as $activityId => $status) {

            $checkValidation1 = $this->cpwValidation->where('cpw_activity_id', $activityId)->where('validation', 'required')->first();
            if ($checkValidation1) {

                if ($status === 'Tidak' || $status == '') {

                    $checkValidation = $this->cpwValidation->where('cpw_activity_id', $activityId)->first();

                    if ($checkValidation) {

                        if ($checkValidation->validation == 'required' && (!isset($this->varianInputs[$activityId]) || empty($this->varianInputs[$activityId]))) {

                            $this->addError('varianInputs.' . $activityId, 'Wajib di isi');
                            $this->addError('keteranganInputs.' . $activityId, 'Keterangan pada inputan' . ' ' . $this->findActivity($activityId));
                            $errorsFound = true;
                        }
                    }
                }
            }
        }


        if ($errorsFound) {
            return;
        }


        $this->cpwSelectedStore($data);

        $this->afterSave();
    }

    private function findActivity($activityId)
    {
        // Find the activity and only select the `title_activity` column
        $activity = CpwActivity::select('title_activity')->find($activityId);

        // Return the `title_activity` if the activity is found, otherwise return null or a default message
        return $activity ? $activity->title_activity : 'Activity not found';
    }



    private function cpwSelectedStore($data)
    {

     
        if ($data) {
            # code...
            foreach ($data['activityStatuses'] as $cpw_activity_id => $selected) {
                $varian = $data['varianInputs'][$cpw_activity_id] ?? null;
    
                $store = [
                    'cpw_header_id' => $this->header_id,
                    'cpw_activity_id' => $cpw_activity_id,
                    'selected' => $selected,
                    'varian' => $varian,
                    'hari_ke' => $this->hari_ke,
                    'user_id' => $this->user_id,
                    'date_selected' => $this->date_selected,
                ];
    
                CpwSelected::create($store);
            }
    
            $this->reset(['activityStatuses', 'varianInputs', 'cpwValidation']);
            session()->flash('success', 'Data berhasil di simpan');
        } else {
            session()->flash('alert', 'Data tidak boleh kosong !!');

        }
        
    }


    public function render()
    {

        
        return view('livewire.form.cpw.create', [
            'cpwActivities' => $this->cpwActivitys,
        ]);
    }
}
