<?php

namespace App\Http\Livewire\Form\Cpw;

use App\CpwActivity;
use App\CpwActivityValidation;
use App\CpwHeader;
use App\CpwSelected;
use Livewire\Component;

class Edit extends Component
{

    public $mForm;
    public $NoReg;
    public $cpwActivitys;
    public $hari_ke;
    public $activityStatuses = [];
    public $varianInputs = [];
    public $varianValidation = [];
    public $cpwValidation;
    public $show = false;
    public $header_id;
    public $header;
    public $user_id;
    public $date_selected;
    public $isDateChange = false;


    public $cpwSelected;


    protected $listeners = [
        'editItem',
    ];

    public function editItem($hariKe)
    {
        $this->hari_ke = $hariKe;
        $this->initialize();
    }

    public function mount($mForm, $NoReg, $header_id = null)
    {
        if (!is_null($header_id)) {
            $this->header_id = $header_id;
        } else {
            $this->header_id = null; // Or some default value if needed
        }

        $this->mForm = $mForm;
        $this->NoReg = $NoReg;
        $this->initialize();
    }

    private function initialize()
    {
        $this->loadCpwActivity();
        $this->checkCpwSelected();
        $this->loadCpwActivityValidation();
    }

    public function loadCpwActivity()
    {
        if ($this->mForm) {
            // Retrieve activities with the first filtered validation
            $this->cpwActivitys = CpwActivity::where('mForm_id', $this->mForm->id)->orderBy('no', 'asc')
                ->get();
        } else {
            $this->cpwActivitys = collect(); // Empty collection to avoid null issues
        }
    }


    public function loadCpwActivityValidation()
    {
        // Pastikan hari_ke sudah ter-set
        if (is_null($this->hari_ke)) {
            return;
        }
        // Ensure that cpwActivitys is loaded before proceeding

        if ($this->cpwActivitys && $this->cpwActivitys->isNotEmpty()) {
            $activityIds = $this->cpwActivitys->pluck('id')->toArray();

            $this->cpwValidation = CpwActivityValidation::whereIn('cpw_activity_id', $activityIds)->where('hari_ke', $this->hari_ke)->get();
        } else {

            $this->cpwValidation = collect(); // Empty collection to avoid null issues
        }
    }

    public function updateActivityStatus($activityId, $status)
    {
        // Update the activity status
        $this->activityStatuses[$activityId] = $status;

        // If the status is 'Tidak', check the validation requirements
        if ($status === 'Tidak') {
            // Find the corresponding validation rule for the activity
            $checkValidation = $this->cpwValidation->firstWhere('cpw_activity_id', $activityId);

            // If the validation is required, set the varianValidation for this activity
            if (isset($checkValidation) && $checkValidation->validation === 'required') {
                $this->varianValidation[$activityId] = 'required';
            } else {
                $this->varianValidation[$activityId] = '';
                $this->varianInputs[$activityId] = '';
            }
        } else {
            // Reset varianValidation and varianInputs when status is not 'Tidak'
            $this->varianValidation[$activityId] = '';
            $this->varianInputs[$activityId] = '';
        }
    }

    public function updated($propertyName)
    {
        if ($propertyName === 'date_selected') {
            $this->isDateChange = true;
        }
    }




    public function checkCpwSelected()
    {

        // Pastikan hari_ke sudah ter-set
        if (is_null($this->hari_ke)) {
            return;
        }

        $this->header = CpwHeader::find($this->header_id);



        if ($this->header) {

            $this->cpwSelected = $this->header->cpwSelected()
                ->where('hari_ke', $this->hari_ke)
                ->get();

            foreach ($this->cpwSelected as $selected) {
                $this->activityStatuses[$selected->cpw_activity_id] = $selected->selected;
                $this->varianInputs[$selected->cpw_activity_id] = $selected->varian ?? '';
            }

            $firstItem = $this->cpwSelected->first();
            if ($firstItem) {
                $this->date_selected = $firstItem->date_selected;
            } else {
                $this->date_selected = null; // Atur nilai default jika koleksi kosong
            }
        }
    }

    public $rules = [
        'activityStatuses.*' => 'nullable', // Ensure each checkbox is required
        'varianInputs.*' => 'nullable|string|max:100', // If filled, must be a string and within the character limit
    ];

    public function save()
    {

        // Perform validation
        $data = $this->validate();

        // Now check if varianInput is required when 'Tidak' is selected
        $errorsFound = false;
        // Now check if varianInput is required when 'Tidak' is selected
        foreach ($this->activityStatuses as $activityId => $status) {

            $checkValidation1 = $this->cpwValidation->where('cpw_activity_id', $activityId)->where('validation', 'required')->first();
            if ($checkValidation1) {

                if ($status === 'Tidak' || $status == '') {

                    $checkValidation = $this->cpwValidation->where('cpw_activity_id', $activityId)->first();

                    if ($checkValidation) {

                        if ($checkValidation->validation == 'required' && (!isset($this->varianInputs[$activityId]) || empty($this->varianInputs[$activityId]))) {

                            $this->addError('varianInputs.' . $activityId, 'Wajib di isi');
                            $this->addError('keteranganInputs.' . $activityId, 'Keterangan pada inputan' . ' ' . $this->findActivity($activityId));
                            $errorsFound = true;
                        }
                    }
                }
            }
        }


        if ($errorsFound) {
            return;
        }


        $this->cpwSelectedStore($data);
    }

    private function findActivity($activityId)
    {
        // Find the activity and only select the `title_activity` column
        $activity = CpwActivity::select('title_activity')->find($activityId);

        // Return the `title_activity` if the activity is found, otherwise return null or a default message
        return $activity ? $activity->title_activity : 'Activity not found';
    }



    private function cpwSelectedStore($data)
    {
        foreach ($data['activityStatuses'] as $cpw_activity_id => $selected) {
            $varian = $data['varianInputs'][$cpw_activity_id] ?? null;

            // Cari apakah data cpwSelected sudah ada
            $existing = CpwSelected::where('cpw_header_id', $this->header_id)
                ->where('cpw_activity_id', $cpw_activity_id)
                ->where('hari_ke', $this->hari_ke)
                ->first();

                if ($existing) {
                    // Prepare the data to update
                    $updateData = [
                        'selected' => $selected,
                        'varian' => $varian,
                    ];
                
                    // Add date_selected if it has changed
                    if ($this->isDateChange) {
                        $updateData['date_selected'] = $this->date_selected;
                    }
                
                    // Perform a single update call
                    $existing->update($updateData);
                }
        }

        $this->reset(['activityStatuses', 'varianInputs', 'cpwValidation']);


        $this->initialize();
        session()->flash('message', 'Data updated successfully!');
    }



    public function render()
    {


        return view('livewire.form.cpw.edit', [
            'cpwActivities' => $this->cpwActivitys,
        ]);
    }
}
