<?php

namespace App\Http\Livewire\Form\Cpw\Header;

use App\CpwHeader;
use App\Registrasi;
use App\Services\MainFormRecordService;
use App\SIMtrDataRegPasien;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Livewire\Component;

class Create extends Component
{

    public $nama_pasien;
    public $tgl_lahir;
    public $NRM;
    public $jenis_kelamin;
    public $diagnosaMRS;
    public $diagnosaMedisAwal;
    public $diagnosaMedisPenyerta;
    public $diagnosaMedisAkhir;
    public $komplikasi;
    public $tindakan;
    public $bb;
    public $tgl_mrs;
    public $tgl_keluar = null;
    public $rujukan;
    public $kode_icd;
    public $ruangan;
    public $kelas;
    public $rencana_rawat;
    public $lama_rawat;

    public $mForm;
    public $NoReg;

    public $section_id;

 
    

    public function mount($mForm, $NoReg)
    {

        $this->mForm = $mForm;
        $this->NoReg = $NoReg;
        $this->filledData();
    }

    public function filledData()
    {

        $registrasi = Registrasi::where('NoReg', $this->NoReg)->first();
        $this->nama_pasien = $registrasi->pasien->NamaPasien;
        $this->tgl_lahir = $registrasi->pasien->TglLahir;
        $this->NRM = $registrasi->NRM;
        $this->jenis_kelamin =  $registrasi->pasien->JenisKelamin;
        $this->ruangan = $registrasi->NoKamar . ' ' .  $registrasi->NoBed;
        $this->section_id = Session::get('section');
        $date = \Carbon\Carbon::parse($registrasi->TglReg)->format('Y-m-d');
        $this->tgl_mrs = $date;

    }

    protected $rules = [
        'nama_pasien' => 'required|string|max:100',
        'tgl_lahir' => 'required|date',
        'NRM' => 'required|string|max:100',
        'jenis_kelamin' => 'nullable|string|max:10',
        'diagnosaMRS' => 'nullable|string|max:250',
        'diagnosaMedisAwal' => 'nullable|string|max:250',
        'diagnosaMedisPenyerta' => 'nullable|string|max:250',
        'diagnosaMedisAkhir' => 'nullable|string|max:250',
        'komplikasi' => 'nullable|string|max:250',
        'tindakan' => 'nullable|string|max:250',
        'bb' => 'nullable|integer',
        'tgl_mrs' => 'required|date',
        'tgl_keluar' => 'nullable|date',
        'rujukan' => 'nullable|string|max:10',
        'kode_icd' => 'nullable|string|max:10',
        'ruangan' => 'nullable|string|max:10',
        'kelas' => 'nullable|string|max:50',
        'rencana_rawat' => 'required|integer',
        'lama_rawat' => 'nullable|integer',
    ];

    public function save()
    {
        // Validate the form data
        $validatedData = $this->validate();

        // Convert empty strings to null for integer fields
        if ($validatedData['lama_rawat'] === '') {
            $validatedData['lama_rawat'] = null;
        }

        if ($validatedData['rencana_rawat'] === '') {
            $validatedData['rencana_rawat'] = null;
        }

        if ($validatedData['tgl_keluar'] === '') {
            $validatedData['tgl_keluar'] = null;
        }

        if ($validatedData['tgl_mrs'] === '') {
            $validatedData['tgl_mrs'] = null;
        }


        // Add additional fields
        $validatedData['mForm_id'] = $this->mForm->id;
        $validatedData['NoReg'] = $this->NoReg;
        $validatedData['section_id'] = $this->section_id;
 
        // Create the record in the database
        $form_destination = CpwHeader::create($validatedData);

        $this->createToMainRecoed($form_destination);

        //Redirect and flash success message
        return redirect()->route('dashboard.medical.pathway.edit', [
            'NoReg' => $this->NoReg,
            'slug' => $this->mForm->slug,
            'id' => $form_destination->id,
        ])->with('message', 'Data pasien berhasil disimpan.');
    }

    public function createToMainRecoed($form_destination)
    {

        $data = [
            'mForm_id' => $this->mForm->id,
            'form_destination_id' => $form_destination->id,
            'NoReg' => $this->NoReg,
            'NRM' => $this->NRM,
            'section_id' => $this->section_id,
        ];
        
        $createBy = Auth::user()->id;
        $mainFormRecordService = new MainFormRecordService;
        $mainFormRecordService->createMainRecord($data, $createBy);

    }

    public function render()
    {
        return view('livewire.form.cpw.header.create');
    }
}
