<?php

namespace App\Http\Livewire\Form\Cpw\Header;

use App\CpwHeader;
use App\Services\MainFormRecordService;
use Carbon\Carbon;
use Livewire\Component;

class Edit extends Component
{
    public $nama_pasien;
    public $tgl_lahir;
    public $NRM;
    public $jenis_kelamin;
    public $diagnosaMRS;
    public $diagnosaMedisAwal;
    public $diagnosaMedisPenyerta;
    public $diagnosaMedisAkhir;
    public $komplikasi;
    public $tindakan;
    public $bb;
    public $tgl_mrs;
    public $tgl_keluar;
    public $rujukan;
    public $kode_icd;
    public $ruangan;
    public $kelas;
    public $rencana_rawat;
    public $lama_rawat;
    public $keterangan_lama_rawat;
 
    public $mForm;
    public $NoReg;

    public $cpwHeader;
    public $header_id = null;

    public $is_out = false;
     
    protected $rules = [
        'diagnosaMRS' => 'nullable|string|max:250',
        'diagnosaMedisAwal' => 'nullable|string|max:250',
        'diagnosaMedisPenyerta' => 'nullable|string|max:250',
        'diagnosaMedisAkhir' => 'nullable|string|max:250',
        'komplikasi' => 'nullable|string|max:250',
        'tindakan' => 'nullable|string|max:250',
        'bb' => 'nullable|sometimes|integer',
        'tgl_mrs' => 'required|date',
        'tgl_keluar' => 'nullable|date',
        'rujukan' => 'nullable|string|max:10',
        'kode_icd' => 'nullable|string|max:10',
        'ruangan' => 'nullable|string|max:10',
        'kelas' => 'nullable|string|max:50',
        'rencana_rawat' => 'required|sometimes|integer',
        'lama_rawat' => 'nullable|sometimes|integer',
        'keterangan_lama_rawat' => 'nullable|string|max:200'
    ];

    public function mount($mForm, $NoReg, $header_id)
    {
        $this->mForm = $mForm;
        $this->NoReg = $NoReg;

        if ($header_id) {
            $this->header_id = $header_id;
            $this->filledData();
        } else {
            session()->flash('error', 'Header ID tidak ditemukan.');
            return; // Stop further execution if header_id is missing
        }
    }

    public function filledData()
    {
        $this->cpwHeader = CpwHeader::find($this->header_id);
        if ($this->cpwHeader) {
            $this->fill($this->cpwHeader->toArray());

            if($this->tgl_mrs && $this->tgl_keluar && $this->lama_rawat){
                $this->is_out = true;
            }
        } else {
            session()->flash('error', 'Data pasien tidak ditemukan.');
            return;
        }
    }

    public function save()
    {
        
        $validatedData = $this->validate();
        $validatedData['is_out'] = $this->is_out;

        if ($this->cpwHeader) {
            $this->cpwHeader->update($validatedData);

           //melakukan update tanggal keluar di tbMainRecord
            $this->updateIsOut($this->cpwHeader->id);

            session()->flash('message', 'Data pasien berhasil disimpan.');
        } else {
            session()->flash('error', 'Data pasien tidak ditemukan.');
        }
    }
    public function updated()
    {
         
        // Ensure both dates are set before calculating
        if ($this->tgl_mrs && $this->tgl_keluar) {
            // Use Carbon to parse the dates and calculate the difference in days
            $start = Carbon::parse($this->tgl_mrs);
            $end = Carbon::parse($this->tgl_keluar);
            $this->lama_rawat = $end->diffInDays($start);
        }
    }

    public function updateIsOut($header_id){

        $updateMainForm= new MainFormRecordService;
        $updateMainForm->updateIsOut($header_id,$this->tgl_keluar);

    }


    public function render()
    {
        return view('livewire.form.cpw.header.edit');
    }
}
