<?php

namespace App\Http\Livewire\Form\Cpw;

use App\CpwSelected;
use Livewire\Component;

class Index extends Component
{
    public $mForm;
    public $NoReg;
    public $header_id;
    public $activeTab = null; // default tab

    protected $listeners = [
        'showPreview',
         'showEdit'
    ];

    public function showPreview(){
      $this->setActiveTab('preview');
    }

    public function showEdit($hariKe)
    {
        // Emit event to the 'editItem' method in the 'Edit' component
        $this->emitTo('form.cpw.edit', 'editItem', $hariKe);

        // Optionally, set the active tab to 'edit'
        $this->setActiveTab('edit');
    }

    public function setActiveTab($tab)
    {
        $this->activeTab = $tab;
    }

    public function checkData(){

        $selected = CpwSelected::where('cpw_header_id', $this->header_id)->count();
        if($selected == 0){
            $this->setActiveTab('create');
        }else{
            $this->setActiveTab('preview');
        }
    }


    public function mount($mForm, $NoReg, $header_id)
    {

        $this->mForm = $mForm;
        $this->NoReg = $NoReg;
        $this->header_id = $header_id;
        $this->checkData();
    }
    public function render()
    {
        return view('livewire.form.cpw.index');
    }
}
