<?php

namespace App\Http\Livewire\Form\Cpw;

use App\CpwActivity;
use App\CpwSelected;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class Preview extends Component
{
    public $mForm;
    public $NoReg;
    public $header_id;
    public $selecteds;
    public $varians;
    public $cpwActivitys;

    public $showBtn = true;

    protected $listeners = [
        'showPreview' => 'showPreview',
    ];
     

 
    public function mount($mForm, $NoReg, $header_id = null)
    {

        if (!is_null($header_id)) {

            $this->header_id = $header_id;

        } else {

            $this->header_id = null; // Or some default value if needed

        }

        $this->mForm = $mForm;
        $this->NoReg = $NoReg;
        $this->initialLoad();
        $this->showBtnEdit();
       
    }

    public function initialLoad(){
        $this->loadCpwActivity();
        $this->loadSelectedCpw();
        $this->loadVarianCpw();
       
    }

    public function loadSelectedCpw(){

        $this->selecteds = DB::table('cpw_selecteds') 
        ->where('cpw_header_id', $this->header_id)
        ->orderBy('hari_ke')  // Order the records sequentially by hari_ke
        ->get()
        ->groupBy('hari_ke'); 
    }

    public function loadVarianCpw(){

        $this->varians = CpwSelected::where('cpw_header_id', $this->header_id)
        ->whereNotNull('varian')
        ->where('varian', '!=', '')
        ->with('cpwActivity','createdBy')  // Eager load the cpwActivity relationship
        ->select('cpw_activity_id', 'varian', 'hari_ke','user_id')->orderBy('created_at', 'asc')
        ->get();

         

    }

    public function loadCpwActivity()
    {
        if ($this->mForm) {
            // Retrieve activities with the first filtered validation
            $this->cpwActivitys = CpwActivity::where('mForm_id', $this->mForm)->orderBy('no', 'asc')
                ->get();
        } else {

            $this->cpwActivitys = collect(); // Empty collection to avoid null issues

        }
    }

    public function showPreview(){

        $this->initialLoad();
        $this->showBtnEdit();

        


    }


    public function editItem($harike){
 
        
        $this->emit('showEdit', $harike);

    }

    

    public function showBtnEdit()
    {
        // Alternatively, get specific segments of the path
        $segment4 = request()->segment(4);
        
        if($segment4 != 'form'){
            $this->showBtn = false;
        }

       
    }

   
 

    public function render()
    {
        return view('livewire.form.cpw.preview');
    }
}
