<div>
    @php
        $currentTitle = null;
        $rowspan = 0;
        $currentSubTitle= null;
    @endphp
    @if (session()->has('message'))
        <div class="alert alert-success mt-3">
            {{ session('message') }}
        </div>
    @endif

    <div class="row" style="height: 600px; overflow:scroll; margin-top: -10px">
        <div class="col-12">
            <table class="table table-bordered table-hover">
                <thead class="card-header">
                    <tr>
                        <th colspan="5">
                            
                            <div class="d-flex justify-content-between">
                                <h5>Edit Asesment </h5> <span><input wire:model='date_selected' type="date" class="form-control"></span>
                            </div>
                        </th>
                    </tr>
                </thead>
                <thead>
                    <tr>
                        <th colspan="2" style="width: 20%">Kegiatan</th>
                        <th style="width: 30%">Uraian Kegiatan</th>
                        <th style="width: 30%">Hari Rawat Ke {{ $hari_ke }}</th>
                        <th style="width: 20%">Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($cpwActivitys as $index => $activity)
                        @php
                            $firstValidation = $activity->firstFilteredValidation($hari_ke);
                        @endphp

                        @if ($currentTitle !== $activity->title_activity)
                            @php
                                $currentTitle = $activity->title_activity;
                                $rowspan = 1;
                                for ($i = $index + 1; $i < count($cpwActivitys); $i++) {
                                    if ($cpwActivitys[$i]->title_activity === $currentTitle) {
                                        $rowspan++;
                                    } else {
                                        break;
                                    }
                                }
                            @endphp
                            <tr>

                                <td rowspan="{{ $rowspan }}">{{ $activity->title_activity }}  
                                </td>
                            @else
                            <tr>
                        @endif

                        @if ($currentSubTitle !== $activity->sub_title_activity)
                            @php
                                $currentSubTitle = $activity->sub_title_activity;
                                $rowspan2 = 1;
                                for ($i = $index + 1; $i < count($cpwActivitys); $i++) {
                                    if ($cpwActivitys[$i]->sub_title_activity === $currentSubTitle) {
                                        $rowspan2++;
                                    } else {
                                        break;
                                    }
                                }
                            @endphp
                            <td rowspan="{{ $rowspan2 }}">
                                <small> {{ $activity->sub_title_activity }}</small>
                            </td>
                        @else
                        @endif

                        <td>{{ $activity->activity }}
                            @if ($firstValidation)
                                @if ($firstValidation->validation == 'required')
                                    *
                                @elseif($firstValidation->validation == 'nullable')
                                    **
                                @else
                                @endif
                            @else
                            @endif
                        </td>
                        <td {!! $firstValidation != null ? 'style="background-color: antiquewhite;"' : '' !!}>
                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="ya_{{ $activity->id }}"
                                    wire:model="activityStatuses.{{ $activity->id }}"
                                    wire:change="updateActivityStatus('{{ $activity->id }}', 'Ya')" value="Ya">
                                <label class="form-check-label" for="ya_{{ $activity->id }}">Ya</label>
                            </div>

                            <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" id="tidak_{{ $activity->id }}"
                                    wire:model="activityStatuses.{{ $activity->id }}"
                                    wire:change="updateActivityStatus('{{ $activity->id }}', 'Tidak')" value="Tidak">
                                <label class="form-check-label" for="tidak_{{ $activity->id }}">Tidak</label>
                            </div>

                            @error('activityStatuses.' . $activity->id)
                                <span class="text-danger">{{ $message }}</span>
                            @enderror


                            @if (isset($activityStatuses[$activity->id]) && $activityStatuses[$activity->id] === 'Tidak')
                                @if ($firstValidation && $firstValidation->validation == 'required')
                                    <div class="mt-2 varian-form">
                                        <input type="text" maxlength="100" class="form-control form-control-sm"
                                            wire:model="varianInputs.{{ $activity->id }}" placeholder="Keterangan">

                                        @error('varianInputs.' . $activity->id)
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                @else
                                @endif
                            @endif

                        </td>
                        <td>{{ $activity->activity_description }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <ul>
                @foreach ($errors->get('keteranganInputs.*') as $errorMessages)
                    @foreach ($errorMessages as $message)
                        <li>
                            <span class="text-danger">{{ $message }}</span>
                        </li>
                    @endforeach
                @endforeach
            </ul>
        </div>
    </div>

    <div>
        <button wire:click="save" class="btn btn-primary mt-3" wire:loading.attr="disabled" wire:target="save">
            <span wire:loading.remove wire:target="save"><i class="mdi mdi-content-save"></i> Simpan</span>
            <span wire:loading wire:target="save"><i class='bx bx-loader-alt bx-spin'></i> Simpan</span>
        </button>


        <button class="btn btn-secondary mt-3" wire:click="$emitTo('form.cpw.index', 'showPreview')">Batal</button>

    </div>
</div>
