<div>
    @if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif
    <form wire:submit.prevent="save">

        <div class="row">

            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="diagnosaMRS">Diagnosa MRS</label>
                    <input type="text" id="diagnosaMRS" class="form-control" wire:model="diagnosaMRS">
                    @error('diagnosaMRS') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="diagnosaMedisAwal">Diagnosa Medis Awal</label>
                    <input type="text" id="diagnosaMedisAwal" class="form-control" wire:model="diagnosaMedisAwal">
                    @error('diagnosaMedisAwal') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="diagnosaMedisPenyerta">Diagnosa Medis Penyerta</label>
                    <input type="text" id="diagnosaMedisPenyerta" class="form-control" wire:model="diagnosaMedisPenyerta">
                    @error('diagnosaMedisPenyerta') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="bb">Berat Badan</label>
                    <input type="number" id="bb" class="form-control" wire:model="bb">
                    @error('bb') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="tgl_mrs">Tanggal MRS</label>
                    <input type="date" id="tgl_mrs" class="form-control" wire:model="tgl_mrs">
                    @error('tgl_mrs') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    
                    <div class="form-check form-check-primary mb-3">
                        <input class="form-check-input" type="checkbox" wire:model='is_out' id="formCheckcolor1"
                            checked>
                        <label class="form-check-label" for="formCheckcolor1">
                            Apakah pasien sudah keluar ?
                        </label>
                    </div>
                     
                </div>

                @if ($is_out)
                    
                <div class="form-group mb-3">
                    <label for="tgl_keluar">Tanggal Keluar</label>
                    <input type="date" id="tgl_keluar" class="form-control" wire:model="tgl_keluar">
                    @error('tgl_keluar') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group mb-3">
                    <label for="lama_rawat">Lama Rawat (Hari)</label>
                    <input type="number" id="lama_rawat" class="form-control" wire:model="lama_rawat">
                    @error('lama_rawat') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="keterangan_lama_rawat">Keterangan Lama Rawat</label>
                    <input type="text" maxlength="200" id="keterangan_lama_rawat" class="form-control" wire:model="keterangan_lama_rawat">
                    @error('keterangan_lama_rawat') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                @endif

              
            </div>
            <div class="col-md-6">
                <div class="form-group mb-3">
                    <label for="rujukan">Rujukan</label>
                    <input type="text" id="rujukan" class="form-control" wire:model="rujukan">
                   
                    @error('rujukan') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group mb-3">
                    <label for="ruangan">Ruangan</label>
                    <input type="text" id="ruangan" class="form-control" wire:model="ruangan">
                    @error('ruangan') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group mb-3">
                    <label for="kelas">Kelas</label>
                    <select wire:model='kelas' class="form-control">
                        <option>Pilih</option>
                        <option value="Kelas 1">Kelas 1</option>
                        <option value="Kelas 2">Kelas 2</option>
                        <option value="Kelas 3">Kelas 3</option>
                        <option value="VIP A">VIP A</option>
                        <option value="VIP B">VIP B</option>
                        <option value="Executive 1">Executive 1</option>
                        <option value="Executive 2">Executive 2</option>
                        <option value="Suite">Suite</option>
                        <option value="President Suite">President Suite</option>
                    </select>
                    @error('kelas') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
               

               
                <div class="form-group mb-3">
                    <label for="kode_icd">Kode ICD</label>
                    <input type="text" id="kode_icd" class="form-control" wire:model="kode_icd">
                    @error('kode_icd') <span class="text-danger">{{ $message }}</span> @enderror
                </div>

                <div class="form-group mb-3">
                    <label for="rencana_rawat">Rencana Rawat</label>
                    <input type="number" id="rencana_rawat" class="form-control" wire:model="rencana_rawat">
                    @error('rencana_rawat') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group mb-3">
                    <label for="diagnosaMedisAkhir">Diagnosa Medis Akhir</label>
                    <input type="text" maxlength="250" id="diagnosaMedisAkhir" class="form-control" wire:model="diagnosaMedisAkhir">
                    @error('diagnosaMedisAkhir') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
              
            </div>
        </div>

   

        <button type="submit" class="btn btn-primary mt-3" wire:loading.attr="disabled" wire:target="save">
            <span wire:loading.remove wire:target="save"><i class="mdi mdi-content-save"></i> Update</span>
            <span wire:loading wire:target="save"><i class='bx bx-loader-alt bx-spin'></i> Update ...</span>
        </button>

        @if (session()->has('message'))
            <div class="alert alert-success mt-3">
                {{ session('message') }}
            </div>
        @endif
    </form>
</div>
