<div class="card mt-2" id="cpwInput">
    <div class="card-body d-flex justify-content-between">
        <div style="width: 30%">
            <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">
                <li class="nav-item">
                    <a class="nav-link @if($activeTab === 'create') active @endif" data-bs-toggle="tab" href="#create" role="tab" wire:click="setActiveTab('create')">
                        <span class="d-block d-sm-none"><i class="fas fa-home"></i></span>
                        <span class="d-none d-sm-block">Create</span>
                    </a>
                </li>
               
                <li class="nav-item">
                    <a class="nav-link @if($activeTab === 'preview') active @endif" data-bs-toggle="tab" href="#preview" role="tab" wire:click="setActiveTab('preview')">
                        <span class="d-block d-sm-none"><i class="far fa-user"></i></span>
                        <span class="d-none d-sm-block">Preview</span>
                    </a>
                </li>

                @if ($activeTab === 'edit')
                    
                <li class="nav-item">
                    <a class="nav-link @if($activeTab === 'edit') active @endif" data-bs-toggle="tab" href="#edit" role="tab" wire:click="setActiveTab('edit')">
                        <span class="d-block d-sm-none"><i class="fas fa-home"></i></span>
                        <span class="d-none d-sm-block">Edit</span>
                    </a>
                </li>
                @endif
            </ul>
        </div>
        <div style="font-family: Arial, sans-serif; line-height: 1.5;">
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <label 
                    style="
                        width: 20px; 
                        height: 20px; 
                        background-color: antiquewhite; 
                        border: 1px solid #ccc; 
                        margin-right: 8px; 
                        border-radius: 4px;">
                </label>
                <span style="font-size: 14px; color: #333;">Harus di isi</span>
            </div>
            <div style="display: flex; align-items: center; margin-bottom: 8px;">
                <label 
                    style="
                        width: 20px; 
                        height: 20px; 
                        background-color: white; 
                        border: 1px solid #ccc; 
                        margin-right: 8px; 
                        border-radius: 4px;">
                </label>
                <span style="font-size: 14px; color: #333;">Diisi jika diperlukan</span>
            </div>
        </div>
        
        
    </div>
    <div class="card-body">
        <div class="tab-content text-muted">
           
            <h5 class="text-center m-4" wire:loading><i class='bx bx-loader-alt bx-spin'></i> loading ..</h5 class="text-center m-4">
            <div class="tab-pane fade @if($activeTab === 'create') show active @endif" id="create" role="tabpanel">
                @if ($activeTab === 'create')
                    @livewire('form.cpw.create', ['mForm' => $mForm, 'NoReg' => $NoReg, 'header_id' => $header_id])
                @endif
            </div>

            <div class="tab-pane fade @if($activeTab === 'preview') show active @endif" id="preview" role="tabpanel">
                @if ($activeTab === 'preview')
                @livewire('form.cpw.preview', ['mForm' => $mForm->id, 'NoReg' => $NoReg, 'header_id' => $header_id])
                @endif
            </div>

            <div class="tab-pane fade @if($activeTab === 'edit') show active @endif" id="edit" role="tabpanel">
                @if ($activeTab === 'edit')
                @livewire('form.cpw.edit', ['mForm' => $mForm, 'NoReg' => $NoReg, 'header_id' => $header_id])

                @endif
            </div>
        </div>
    </div>
</div>
